<?php

namespace App\Sys\Repository\Branches;

use App\Models\Branch;
use App\Models\User;
use App\Models\UserBranch;
use App\Sys\LogsModelActivity;
use Illuminate\Support\Facades\DB;

class BranchesRepo
{
    use LogsModelActivity;
    private $branch;

    public function __construct()
    {
        $this->branch = new Branch();
    }

    // get all Branch
    public function getAll()
    {
        return $this->branch->with('creator')->get();
    }

    public function getbyid($id)
    {
        return $this->branch->with('creator')->find($id);
    }

    public function pluckAll()
    {
        return $this->branch->pluck('id')->toArray();
    }

    public function createBranch($data)
    {
        $branch = new Branch();
        $branch->name = $data['name'];
        $branch->user_id = auth()->id();
        $branch->save();
        $users = [];
        if (!empty($data['user_id']) && is_array($data['user_id'])) {
            foreach ($data['user_id'] as $id) {
                $userBranch = new UserBranch();
                $userBranch->user_id = $id;
                $userBranch->branch_id = $branch->id;
                $userBranch->save();
                $users[] = $id;
            }
        }
        $userList  =['old'=>[],'new'=>!empty($users) ? User::whereIn('id', $users)->get() : collect()];
        $this->logActivity('branch',$branch,'created',['users'=>$userList]);
        return true;
    }

    public function findBranchById($id)
    {
        return Branch::with('projects', 'users', 'getProjectForm.form', 'creator')->find($id);
    }

    public function updateBranch($data)
    {
        $branch = Branch::find($data['id']);
        $originalBranch = clone $branch;
        $branch->name = $data['name'];
        $branch->user_id = auth()->id();
        $branch->save();
        $oldUserIds = UserBranch::where('branch_id', $branch->id)->pluck('user_id');
        $oldUsers =!empty($oldUserIds)? User::whereIn('id', $oldUserIds)->get():collect();
        $newUsers=collect();
        if (!empty($data['user_id']) && is_array($data['user_id'])) {
            UserBranch::where('branch_id', $branch->id)->delete();
            foreach ($data['user_id'] as $id) {
                $userBranch = new UserBranch();
                $userBranch->user_id = $id;
                $userBranch->branch_id = $branch->id;
                $userBranch->save();
            }
            $newUsers = User::whereIn('id', $data['user_id'])->get();
        }
        $this->logActivity('branch',$branch,'updated',['users'=>['old'=>$oldUsers,'new'=>$newUsers]],$originalBranch);
        return true;
    }

    public function checkUserProject($value)
    {
        return DB::table('user_branches')
            ->where('user_id', $value['user_id'])
            ->where('branch_id', $value['branch_id'])
            ->exists();
    }

    public function adduserProject($data)
    {
        foreach ($data['user_branch'] as $user) {
            if (!$this->checkUserProject($user)) {
                $prUser = new UserBranch();
                $prUser->user_id = $user['user_id'];
                $prUser->branch_id = $user['branch_id'];
                $prUser->save();
            }

        }

        return true;
    }

    public function del($id)
    {
        $data = $this->branch->find($id);
        $data->delete();
         $this->logActivity('branch',$data,'deleted',[]);
         return true;
    }

    public function count()
    {
        return $this->branch->count();
    }
}
