<?php

namespace App\Sys\Repository\Auth;

use App\Models\Branch;
use App\Models\Department;
use App\Models\Project;
use App\Models\Role;
use App\Models\User;
use App\Models\UserBranch;
use App\Models\UserDepartment;
use App\Models\UserProject;
use App\Sys\ApiResponse;
use App\Sys\LogsModelActivity;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;

class AuthRepo
{
    use LogsModelActivity ;

    public function createUser(array $data)
    {
        $user = new User();
        $user->name = $data['name'];
        $user->email = $data['email'];
        $user->employee_number = $data['employee_number'];
        $user->password = $data['password'];
        $user->userType = $data['userType'] ?? 'admin';
        $user->role_id = $data['role_id'];
        $user->phone = $data['phone'] ?? null;
        $user->user_id = auth()->id() ?? ($data['user_id'] ?? null);
        $user->save();

        $newBranches = [];
        $newProjects = [];
        $newDepartments = [];

        if (!empty($data['branches'])) {
            foreach ($data['branches'] as $b) {
                $userBranch = new UserBranch();
                $userBranch->user_id = $user->id;
                $userBranch->branch_id = $b;
                $userBranch->save();
                $newBranches[] = $b;
            }
        }

        if (!empty($data['project'])) {
            foreach ($data['project'] as $b) {
                $userBranch = new UserProject();
                $userBranch->user_id = $user->id;
                $userBranch->project_id = $b;
                $userBranch->save();
                $newProjects[] = $b;
            }
        }

        // Attach departments via pivot table if provided

        if (!empty($data['departments'])) {
            foreach ($data['departments'] as $d) {
                // Expecting $data['departments'] to be an array of department IDs.
                $userDepartment = new UserDepartment();
                $userDepartment->user_id = $user->id;
                $userDepartment->department_id = $d;
                $userDepartment->save();
                $newDepartments[] = $d;
            }
        }
        $role = Role::find($user->role_id);
        $branches = !empty($newBranches) ? Branch::whereIn('id', $newBranches)->get() : collect();
        $projects = !empty($newProjects) ? Project::whereIn('id', $newProjects)->get() : collect();
        $departments = !empty($newDepartments) ? Department::whereIn('id', $newDepartments)->get() : collect();
        $realtion =[
            'role'=>['old' => [],'new' =>$role ? collect([$role]) : collect()],
            'branches'=>['old'=>[],'new'=>$branches],
            'projects'=>['old'=>[],'new'=>$projects],
            'departments'=>['old'=>[],'new'=>$departments],
        ];
        $this->logActivity('user',$user,'created',$realtion);

        return $user;
    }

    private function syncWithUserBranch($user_id, $branch_id)
    {
        $userBranch = new UserBranch();
        $userBranch->user_id = $user_id;
        $userBranch->branch_id = $branch_id;
        $userBranch->save();
    }

    public function storeToken($email, $token)
    {
        DB::table('password_reset_tokens')->updateOrInsert(
            ['email' => $email],
            ['token' => $token, 'created_at' => Carbon::now()->format('Y-m-d H:i:s')]
        );
    }

    public function isValidToken($email, $token)
    {
        return DB::table('password_reset_tokens')
            ->where('email', $email)
            ->where('token', $token)
            ->exists();
    }

    public function deleteToken($email)
    {
        DB::table('password_reset_tokens')->where('email', $email)->delete();
    }

    public function updatePassword($email, $hashedPassword)
    {
        return User::where('email', $email)->update(['password' => $hashedPassword]);
    }

    private function prepareUserLogAttributes(User $user, $role, $branches, $projects, $departments)
    {
        return [
            'id' => $user->id,
            'name' => $user->name,
            'email' => $user->email,
            'employee_number' => $user->employee_number,
            'phone' => $user->phone,
            'role' => $role ? [
                'id' => $role->id,
                'name' => $role->name
            ] : null,
            'branches' => collect($branches)->map(fn($b) => ['id' => $b->id, 'name' => $b->name])->toArray(),
            'projects' => collect($projects)->map(fn($p) => ['id' => $p->id, 'name' => $p->name])->toArray(),
            'departments' => collect($departments)->map(fn($d) => ['id' => $d->id, 'name' => $d->name])->toArray(),
        ];
    }
}
