<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class formComplexGroups extends Model
{

    protected $table = "form_complex_groups";

    public function form()
    {
        return $this->belongsTo(Form::class, 'form_id');
    }

    public function children()
    {
        return $this->hasMany(formComplexGroups::class, 'parent_id');
    }

    public function parent()
    {
        return $this->belongsTo(formComplexGroups::class, 'parent_id');
    }

  public function project()
  {
      return $this->belongsTo(Project::class,'project_id');
  }

  public function branch()
  {
      return $this->belongsTo(Branch::class,'branch_id');
  }

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
