<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Models\Activity;
use Spatie\Activitylog\Traits\LogsActivity;
class NotificationBar extends Model
{
    use HasFactory, LogsActivity;
    protected $table ="notification_bars";
    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;
    protected $fillable = ['text', 'active', 'user_id'];

    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes)
            ->logOnlyDirty()
            ->useLogName('notification_bars')
            ->dontSubmitEmptyLogs();
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $attributes = [
            'old' => [],
            'new' => [],
        ];

        if ($eventName === 'created') {
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'updated') {
            $attributes['old'] = $this->getOriginal();
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'deleted') {
            $attributes['old'] = $this->getOriginal();
        }

        $attributes['old'] = $this->formatTimestamps($attributes['old']);
        $attributes['new'] = $this->formatTimestamps($attributes['new']);
        $activity->properties = ['attributes' => $attributes];
    }

    protected function formatTimestamps(array $attributes): array
    {
        foreach (['created_at', 'updated_at'] as $key) {
            if (isset($attributes[$key])) {
                try {
                    $attributes[$key] = \Carbon\Carbon::parse($attributes[$key])->format('Y-m-d H:i:s');
                } catch (\Exception $e) {

                }
            }
        }

        return $attributes;
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

}
