<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormInput extends Model
{
    use HasFactory;

    public function getOption()
    {
        return $this->hasMany(FormInputOption::class, 'input_id');
    }

    public function form()
    {
        return $this->belongsTo(Form::class, 'form_id');
    }

    public function row()
    {
        return $this->belongsTo(FormRow::class, 'form_row_id');
    }

    public function column()
    {
        return $this->belongsTo(FormColumn::class, 'form_column_id');
    }

    public function options()
    {
        return $this->hasMany(FormInputOption::class, 'input_id');
    }
}
