<?php

namespace App\Models;

use App\Models\FormGroup\FormGroup;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Form extends Model
{
    use HasFactory;

    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function formGroup()
    {
        return $this->belongsTo(FormGroup::class, 'form_group_id');
    }


    public function departments()
    {
        return $this->belongsToMany(Department::class, 'department_forms', 'form_id', 'department_id')
            ->withPivot('form_group_id')
            ->withTimestamps();
    }

    public function getRow()
    {
        return $this->hasMany(FormRow::class, 'form_id')->with('getColumn');
    }

    public function getFormBranchProject()
    {
        return $this->hasMany(FormBranchProject::class, 'form_id');
    }

    public function form_input()
    {
        return $this->hasMany(FormInput::class, 'form_id');
    }

    public function rows()
    {
        return $this->hasMany(FormRow::class, 'form_id')->with('columns.inputs.options');
    }

    public function files()
    {
        return $this->hasMany(FormFiles::class, 'form_id');
    }

    public function ProjectForms()
    {
        return $this->hasMany(ProjectForm::class, 'form_id');
    }

    public function parentForm()
    {
        //return $this->belongsTo(Form::class, 'reference_id')->with('parentForm');
        return $this->belongsTo(Form::class, 'reference_id')->with(['parentForm', 'creator', 'updatedBy']);
    }


}
