<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Activitylog\Models\Activity;

class Department extends Model
{
    use SoftDeletes, LogsActivity;
    protected $table ="department";


    protected static $logAttributes = ['*'];
    protected static $logOnlyDirty = true;
    protected static $submitEmptyLogs = false;
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->logOnly(static::$logAttributes)
            ->logOnlyDirty()
            ->useLogName('department')
            ->dontSubmitEmptyLogs();
    }

    public function tapActivity(Activity $activity, string $eventName)
    {
        $attributes = [
            'old' => [],
            'new' => [],
        ];

        if ($eventName === 'created') {
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'updated') {
            $attributes['old'] = $this->getOriginal();
            $attributes['new'] = $this->getAttributes();
        } elseif ($eventName === 'deleted') {
            $attributes['old'] = $this->getOriginal();
        }

        $attributes['old'] = $this->formatTimestamps($attributes['old']);
        $attributes['new'] = $this->formatTimestamps($attributes['new']);

        $activity->properties = ['attributes' => $attributes];
    }

    protected function formatTimestamps(array $attributes): array
    {
        foreach (['created_at', 'updated_at'] as $key) {
            if (isset($attributes[$key])) {
                try {
                    $attributes[$key] = \Carbon\Carbon::parse($attributes[$key])->format('Y-m-d H:i:s');
                } catch (\Exception $e) {

                }
            }
        }

        return $attributes;
    }
    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }


    public function users()
    {
        return $this->belongsToMany(User::class, 'user_department',  'department_id','user_id');
    }

    public function forms()
    {
        return $this->belongsToMany(Form::class, 'department_forms', 'department_id', 'form_id');
    }

    public function getUsers()
    {
        return $this->belongsTo(User::class,'user_id');
    }
}
