<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubRowsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "single_multi_column" => $this->single_multi_column,
            "single_multi_input" => $this->single_multi_input,
            "type_row" => $this->type_row,
            "sub_column" =>SubColumnResource::collection(
                $this->whenLoaded('getSubColumn') ?
                    $this->getSubColumn->map(function ($me) {
                        return new SubColumnResource($me);
                    }) :
                    null
            )
        ];
    }
}
