<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SubColumnResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            "id" => $this->id,
            "width" => $this->width,
            'inputs' => InputsResource::collection(
                $this->whenLoaded('getInput') ?
                    $this->getInput->map(function ($me) {
                        return new InputsResource($me);
                    }) :
                    null
            )
        ];
    }
}
