<?php

namespace App\Http\Resources\StaticPage;

use Illuminate\Http\Resources\Json\JsonResource;

class StaticPageResource extends JsonResource
{
    public function toArray($request)
    {
        return [
            'id'         => $this->id,
            'title_en'   => $this->title_en,
            'title_ar'   => $this->title_ar,
            'body_en'    => $this->body_en,
            'body_ar'    => $this->body_ar,
            'cover'      => $this->cover ? asset('/' . $this->cover) : null,
            'user_id'    => $this->user_id,
            'user_name' => $this->creator ? $this->creator->name : null,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }
}
