<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class ProjectFormResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'project_name'=>$this->project->name ??null,
            'branch_name'=>$this->branch->name ??null,
            'form_name'=>$this->form->name ??null,
            'form_id'=>$this->form->id ??null,
            'user_id'=>$this->user_id,
            'user_name'=>$this->creator ? $this->creator->name : null, // Get the user's name
            'form_desc'=>$this->form->description ??null,
            'type'=>$this->type,
            'status'=>$this->status,
            'expiration_date'=>$this->expiration_date,
            'created_at'=>$this->created_at,
            'last_updated'=>$this->updated_at
        ];
    }
}
