<?php

namespace App\Http\Resources;

use App\Http\Resources\FormGroup\FormGroupResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FormsResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'step' => $this->step,
            'description' => $this->description,
            'type' => $this->type,
            'form_group_id' => $this->form_group_id,
            'form_group_name'=>$this->formGroup->name ?? null,
            'form_group' => FormGroupResource::make($this->whenLoaded('formGroup')),
            'order_of_cycle' => $this->order_of_cycle,
            'order_of_arrangement' => $this->order_of_arrangement,
            'user_id' => $this->user_id,
            'user_name' => $this->creator ? $this->creator->name : null,
            'next_send_date' => $this->next_send_date,
            'is_active' => $this->is_active,
            'approved' => $this->approved,
            'chart' => $this->chart,
            'created_at'=>$this->created_at,
            "send_type" => $this->type == 'fixed' ? null : $this->calculateTime()
        ];
    }

    private function calculateTime()
    {
        if ($this->periodic_oneTime == "oneTime") {
            return "send on " . $this->onetime_send;
        } else {
            $name = $this->periodic_type;
            if ($this->periodic_type == "weekly") {
                $day_name = date('l', strtotime("Sunday +{$this->week_day} days"));
                return $name . ' - ' . $day_name;
            } elseif ($this->periodic_type == "monthly") {
                $day_name = date('l', strtotime(date('Y-m-d') . " +{$this->month_day} days"));
                $month_name = date('F', strtotime(date('Y-m-d') . " +{$this->month_day} days"));
                return $name . ' - ' . $month_name . '-' . $this->month_day . '-' . $day_name;
            } elseif ($this->periodic_type == "quarterly") {
                $current_date = new \DateTime(); // Get the current date/time
                $input_date = new \DateTime($this->quarter_start_date);
                while ($input_date < $current_date) {
                    $input_date->add(new \DateInterval('P3M'));
                }
                return $name .' - '. $input_date->format('Y-m-d');
            }

        }
        return null;
    }
}
