<?php

namespace App\Http\Resources;

use App\Http\Resources\FormGroup\FormGroupResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FormsByIdResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'step' => $this->step,
            'description' => $this->description,
            'type' => $this->type,
            'form_group_id' => $this->form_group_id,
            'form_group' => FormGroupResource::make($this->whenLoaded('formGroup')),
            'next_send_date' => $this->next_send_date,
            'periodic_oneTime' => $this->periodic_oneTime,
            'periodic_type' => $this->periodic_type,
            'onetime_send' => $this->onetime_send,
            'deadline_by_num_of_days' => $this->deadline_by_num_of_days,
            'week_day' => $this->week_day,
            'month_day' => $this->month_day,
            'quarter_start_day' => $this->quarter_start_day,
            'footer_print' => $this->footer_print,
            'is_active' => $this->is_active,
            'order_of_cycle' => $this->order_of_cycle,
            'order_of_arrangement' => $this->order_of_arrangement,
            'approved' => $this->approved,
            'chart' => $this->chart,
            'title_print' => $this->title_print,
            'created_at'=>$this->created_at,
            'user_id' => $this->user_id,
            'user_name' => $this->creator ? $this->creator->name : null,
            "one_time_type"=> $this->type == "general" && $this->periodic_oneTime == "oneTime"?$this->getOneTimeType():null,
            'last_send_form'=>$this->type =="general"? $this->ProjectForms->first()?->created_at?->format('Y-m-d'):null,
            "files"=> FilesResource::collection(
                $this->whenLoaded('files') ?
                    $this->files->map(function ($me) {
                        return new FilesResource($me);
                    }) :
                    null
            ),
            "rows"=> RowsResource::collection(
                $this->whenLoaded('getRow') ?
                    $this->getRow->map(function ($me) {
                        return new RowsResource($me);
                    }) :
                    null
            )
        ];
    }
    private function getOneTimeType()
    {
        $created = $this->created_at->format('Y-m-d');
        $send = $this->onetime_send != null ? $this->onetime_send : ($this->next_send_date ?? $created) ;

        if($created == $send)
            return 'today';
        else
            return 'specific';
    }
}
