<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class FilesResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        $data = $this->convertToBase64($this->path);
        return [
            "id"=>$this->id,
            "type"=>$data != null ? $data['type'] : null,
            "path"=>$data != null ? $data['value'] : null,
            "url"=>$data != null ? $data['path'] : null,
            "rel"=>url('/'.$this->path),
            "file_name"=>$this->file_name,
        ];
    }

    private function convertToBase64($filePath)
    {
        /*
        if (!$filePath) {
            return null;
        }


        // التحقق مما إذا كان المسار نسبيًا أم كاملًا
        $fullPath = str_starts_with($filePath, public_path()) ? $filePath : public_path($filePath);

        if (!file_exists($fullPath)) {
            return null; // إذا كان الملف غير موجود، لا ترجعه
        }

        $fileContent = file_get_contents($fullPath);
        $fileMimeType = mime_content_type($fullPath);

        return [
            'type'=>$fileMimeType,
            'value'=>base64_encode($fileContent),
            'path'=>$fullPath
        ];
        */
        $filePath = $this->path; // المسار المخزن في قاعدة البيانات

        if (!$filePath) {
            return null;
        }

// توليد المسار الفعلي للملف
        $fullPath = public_path('/'.$filePath);
        //$fullPath = realpath($fullPath); // التأكد من أنه مسار صالح

        if (!$fullPath || !file_exists($fullPath)) {
            return null; // الملف غير موجود
        }

        $fileContent = file_get_contents($fullPath);
        $fileMimeType = mime_content_type($fullPath) ?: "application/octet-stream"; // تعيين نوع افتراضي

        return [
            'type'  => $fileMimeType, // إرجاع الـ MIME Type
            'value' => base64_encode($fileContent), // تحويل الملف إلى Base64
            'path'  => $fullPath // المسار الحقيقي للملف
        ];
    }


}
