<?php

namespace App\Http\Resources\ComplexFormGroupResource;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;
use App\Http\Resources\ComplexFormGroupResource\ComplexFormGroupResource;

class ComplexFormGroupCollection extends ResourceCollection
{
    public function toArray(Request $request): array
    {
        return [
            'data' => ComplexFormGroupResource::collection($this->collection),
            'links' => $this->paginationLinks(),
            'meta' => [
                'pagination' => [
                    'total'         => $this->total(),
                    'count'         => $this->count(),
                    'per_page'      => $this->perPage(),
                    'current_page'  => $this->currentPage(),
                    'total_pages'   => $this->lastPage(),
                    'next_page_url' => $this->paginationLinks(),
                    'prev_page_url' => $this->paginationprev(),
                ],
            ],
        ];
    }

    protected function paginationLinks()
    {
        $paginator = $this->resource->withQueryString();
        $nextPage  = $paginator->currentPage() + 1;
        return $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;
    }

    protected function paginationprev()
    {
        $paginator = $this->resource->withQueryString();
        $prevPage  = $paginator->currentPage() - 1;
        return $prevPage >= 1 ? $paginator->url($prevPage) : null;
    }
}
