<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Spatie\Activitylog\Models\Activity;

/** @mixin Activity */
class ActivityLogResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'log_name' => $this->log_name,
            'description' => $this->description,
            //'subject_type' => $this->subject_type,
            'subject_id' => $this->subject_id,
           // 'causer_type' => $this->causer_type,
            'causer_id' => $this->causer_id,
            'event' => $this->event,
            'subject'=>$this->whenLoaded('subject'),
            'causer'=>$this->whenLoaded('causer'),
            'properties' => $this->properties,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
