<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\ResourceCollection;

class ActivityLogCollection extends ResourceCollection
{
    public function toArray(Request $request): array
    {
        return [
            'data' => ActivityLogResource::collection($this->collection),
            'links' => $this->paginationLinks(),
            'meta' => [
                'pagination' => [
                    'total' => $this->total(),
                    'count' => $this->count(),
                    'per_page' => $this->perPage(),
                    'current_page' => $this->currentPage(),
                    'total_pages' => $this->lastPage(),
                    'next_page_url' => $this->paginationLinks(),
                    'prev_page_url' => $this->paginationprev()
                ],
            ]
        ];
    }

    protected function paginationLinks()
    {
        $paginator = $this->resource->withQueryString();
        $prevPage = $paginator->currentPage() - 1;
        $nextPage = $paginator->currentPage() + 1;
        $links = $nextPage <= $paginator->lastPage() ? $paginator->url($nextPage) : null;
        return $links;
    }

    protected function paginationprev()
    {
        $paginator = $this->resource->withQueryString();
        $prevPage = $paginator->currentPage() - 1;
        $links = $prevPage >= 1 ? $paginator->url($prevPage) : null;
        return $links;
    }
}
