<?php

namespace App\Http\Requests\StaticPage;

use Illuminate\Foundation\Http\FormRequest;

class StaticPageRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        if($this->isMethod('put') || $this->isMethod('patch')) {
            return [
                'title_en' => 'sometimes|string|max:255',
                'title_ar' => 'sometimes|string|max:255',
                'body_en'  => 'sometimes|string',  // Accepts HTML
                'body_ar'  => 'sometimes|string',  // Accepts HTML
                // 'cover' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048', // Optional image file, max 2MB
            ];
        }

        return [
            'title_en' => 'required|string|max:255',
            'title_ar' => 'required|string|max:255',
            'body_en'  => 'required|string',  // Accepts HTML
            'body_ar'  => 'required|string',  // Accepts HTML
            // 'cover'    => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048', // Optional image file, max 2MB
        ];

    }

    public function messages()
    {
        return [
            'title_en.required' => 'The title in English is required.',
            'title_ar.required' => 'The title in Arabic is required.',
            'body_en.required'  => 'The body in English is required.',
            'body_ar.required'  => 'The body in Arabic is required.',
            'cover.image'       => 'The cover image must be an image file.',
            'cover.max'         => 'The cover image size should not exceed 2MB.',
            'cover.mimes'       => 'The cover image must be a file of type: jpeg, png, jpg, gif, svg.',
        ];
    }
}


