<?php

namespace App\Http\Controllers;

use App\Models\ProjectForm;
use App\Models\ProjectInput;
use Spatie\Activitylog\Models\Activity;

class testControllers extends Controller
{


    public function index($id)
    {
        return Activity::where('log_name','project_form')->get();

        $form = ProjectForm::with('form','project','branch')->find($id);
        //logs
        $inputs = ProjectInput::with('inputs')->where([
            ['project_form_id',$id],['input_type','!=','label']])->get();
        $input =[];
        foreach ($inputs as $inp)
        {
            $input[]=[
                'id'=>$inp->id,
                'label'=>$inp->inputs->label,
                'input_type'=>$inp->input_type,
                'answer'=>$this->getAnswer($inp),
                'file_type'=>$inp->file_type,
                'updated_at'=>$inp->updated_at->format('Y-m-d H:i:s')
            ];
        }
        $attrib=[
            'id'=>$form->id,
            'form_name'=>$form->form->name,
            'status'=>$form->status,
            'project_name'=>$form->project->name ?? null,
            'branch_name'=>$form->branch->name ?? null,
            'updated_at'=>$form->updated_at->format('Y-m-d H:i:s'),
            'inputs'=>$input
        ];

        activity('project_form')
            ->performedOn($form)
            ->causedBy(auth()->user())
            ->event('updated')
            ->withProperties([
                'attributes' => [
                    $attrib
                ]
            ])
            ->log('updated');
    }


    private function getAnswer($input)
    {
        $answer =null;
        if(in_array($input->input_type,['checkbox','radio']))
            $answer = $input->answer_named;
        elseif ($input->input_type == 'file')
            $answer = url($input->answer);
        else
            $answer = $input->answer;


        return $answer;
    }
}
