<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Sys\ApiResponse;
use App\Sys\Services\User\RoleService;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;

class RoleController extends Controller
{
    use ApiResponse;

    /**
     * @var RoleService
     */
    protected $roleService;

    public function __construct()
    {
        $this->roleService = new RoleService();
    }

    /**
     * List roles.
     */
    public function index()
    {
        $roles = $this->roleService->gets();
        return $this->apiResponse(200, 'data', null, $roles);
    }

    /**
     * Create a new role.
     */
    public function store(Request $request)
    {
        $data = $request->all();

        if ($this->roleService->add($data)) {
            return $this->apiResponse(200, 'Role created successfully', null, null);
        }
        return $this->apiResponse(400, 'Role created successfully', $this->roleService->errors(), null);
    }

    /**
     * Return a single role.
     */
    public function show($id)
    {
        if ($role = $this->roleService->get($id)) {
            return $this->apiResponse(200, 'Role', null, $role);

        }

        return $this->apiResponse(400, 'Role', null, $role);
    }

    /**
     * Update an existing role.
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();
        if ($this->roleService->updated($data, $id)) {
            return $this->apiResponse(200, 'Role updated successfully', null, null);
        }
        return $this->apiResponse(400, 'Role created successfully', $this->roleService->errors(), null);
    }

    public function delete($id)
    {
        if ($this->roleService->delete($id)) {
            return $this->apiResponse(200, 'Role deleted successfully', null, null);
        }
        return $this->apiResponse(400, 'Role not found', null, null);
    }
    public function getPermissions()
    {

      return  $permissions = config('global.permissions');
        return $this->apiResponse(200, 'Roles', null, $permissions);
    }
}
