<?php

namespace App\Http\Controllers;

use App\Http\Resources\FormsAllCollection;
use App\Models\Form;
use App\Models\FormInputOption;
use App\Models\ProjectForm;
use App\Sys\ApiResponse;
use App\Sys\Services\Form\FormService;
use Illuminate\Http\Request;

class ReportsControllers extends Controller
{

    use ApiResponse;

    private $forms;

    public function __construct()
    {
        $this->forms = new FormService();
    }

    public function checkFormDisable($id)
    {
        $forms = $this->forms->checkDisable($id);
        return $this->apiResponse(200, 'Check Forms', null, $forms);
    }

    public function getGeneralReports(Request $request)
    {
       if($forms = $this->forms->getGenralReport($request->all()))
           return $this->apiResponse(200, 'Check Forms', null, $forms);


       $errors = $this->forms->errors();
        return $this->apiResponse(400, 'Check Forms', $errors, null);
    }

    public function getCalcutorRepor(Request $request)
    {
        if($forms = $this->forms->calclutorReports($request->all()))
            return $this->apiResponse(200, 'Check Forms', null, $forms);


        $errors = $this->forms->errors();
        return $this->apiResponse(400, 'Check Forms', $errors, null);
    }

    public function getFormsHaveFiles($type)
    {
        $forms = $this->forms->getFormsHaveFiles($type);
        $collect = new FormsAllCollection($forms);
        return $this->apiResponse(200, 'chart Compelated ', null, $collect);
    }

    public function getfileReports(Request $request)
    {
        if($data = $this->forms->getFileUrl($request->all()))
            return $this->apiResponse(200, 'forms Url ', null, ['url'=>$data]);


        $errors = $this->forms->errors();
        return $this->apiResponse(400, 'Check Forms', $errors, null);
    }
}
