<?php

namespace App\Http\Controllers\ProjectsForms;

use App\Http\Controllers\Controller;
use App\Http\Resources\ComplexFormGroupResource\ComplexFormGroupCollection;
use App\Http\Resources\ProjectFormCollection;
use App\Models\FormRow;
use App\Sys\ApiResponse;
use App\Sys\Repository\formComplexGroupsRepo;
use App\Sys\Services\ProjectsFroms\ProjectsFormServices;
use Illuminate\Http\Request;
use function PHPUnit\Framework\returnArgument;

class ProjectsFormsController extends Controller
{
    use ApiResponse;

    // general form
    private $projectFrom;

    public function __construct()
    {
        $this->projectFrom = new ProjectsFormServices();
    }

    public function sendForms()
    {
        $forms = $this->projectFrom->gets(request());
        $collect = new ProjectFormCollection($forms);
        return $this->apiResponse(200, 'Project- form', null, $collect);
    }

    public function getProjectForm($id)
    {
        if ($data = $this->projectFrom->getInputsForForm($id))
            return $this->apiResponse(200, 'Project- form', null, $data);


        $errors = $this->projectFrom->errors();
        return $this->apiResponse(400, 'send form id ', $errors, null);
    }

    public function submitProjectForms(Request $request)
    {
        $this->projectFrom->sbmit($request->all());
        return $this->apiResponse(200, 'submit finished', null, null);
    }

    public function createFixedForm(Request $request)
    {
        if($id = $this->projectFrom->addFormFixed($request->all()))
            return $this->apiResponse(200, 'send form id ', null, ['project_form_id' => $id]);


        return $this->apiResponse(400, 'send form id ', ['user cant assess this project'],null);
    }
    // Create Complex Form
    public function createComplexForm(Request $request)
    {
        if($id = $this->projectFrom->addFormComplex($request->all()))
            return $this->apiResponse(200, 'send form id ', null, ['project_form_id' => $id]);


        $errors = $this->projectFrom->errors();
        return $this->apiResponse(400, 'send form id ', $errors, null);

    }

    public function test()
    {
        $id = 50;
        return FormRow::whereHas('getProjectInputs', function ($query) use ($id) {
            $query->where('project_form_id', $id);
        })->where('type_row', 'td')
            ->with([
                'getProjectInputs' => function ($query) use ($id) {
                    $query->where('project_form_id', $id);
                }
            ])->get();
    }


    /**
     * Approve a project form.
     *
     * URL example: PUT /api/project-forms/{id}/approve
     *
     * @param int $id The project form ID.
     * @param Request $request
     * @return \Illuminate\Http\Response
     */

    public function approve($id)
    {
        $result = $this->projectFrom->approveForm($id);
        if ($result) {
            return $this->apiResponse(200, 'Project form approved successfully', null, $result);
        }
        return $this->apiResponse(400, 'Error', $this->projectFrom->errors(), null);
    }


    public function getWaitingComplexFormsByDepartments()
    {
        $groups = $this->projectFrom->getWaitingComplexFormsByDepartments();
        $collect =  new ComplexFormGroupCollection($groups);
        return $this->apiResponse(200, 'Waiting complex forms groups retrieved successfully', null, $collect);
    }

    public function countWaitingComplexFormsByDepartments(Request $request)
    {
        // Retrieve department ids from the request body
        $departmentIds = $request->get('department_ids');
        $project_id = $request->get('project_id');
        if (!$departmentIds) {
            return $this->apiResponse(400, 'Error', 'Department id(s) required', null);
        }

        // Normalize to an array if a single department id is provided
        if (!is_array($departmentIds)) {
            $departmentIds = [$departmentIds];
        }

        if (!is_array($project_id)) {
            $project_id = [$project_id];
        }


        // Get the parent complex forms groups via the repository with pagination

        $count = $this->projectFrom->countWaitingByDepartmentIds($departmentIds,$project_id);


        return $this->apiResponse(
            200,
            'Count of waiting complex forms retrieved successfully',
            null,
            ['count' => $count] // Return as object with count key
        );
    }

    public function getParentComplexForms()
    {
        $parentForms = $this->projectFrom->getParentForms();
        $collect=  new ComplexFormGroupCollection($parentForms);
        return $this->apiResponse(200, 'Parent complex forms groups retrieved successfully', null,$collect);
    }

    public function getChildrenForms(Request $request, $parentId)
    {
        // Validate parent ID
        if (!is_numeric($parentId) || $parentId <= 0) {
            return $this->apiResponse(400, 'Error', 'Invalid parent ID', null);
        }
        $limit = $request->get('limit', 30);
        $parent = $this->projectFrom->getCilderandPerant($parentId,$limit);
        $data =  new ComplexFormGroupCollection($parent);
        return $this->apiResponse(200, 'Children forms retrieved successfully', null, $data);
    }
}
