<?php

namespace App\Http\Controllers;

use App\Http\Requests\FormCreateRequest;
use App\Http\Resources\ComplexFormGroupResource\ComplexFormGroupCollection;
use App\Http\Resources\ComplexFormGroupResource\ComplexFormGroupResource;
use App\Http\Resources\FormsAllCollection;
use App\Http\Resources\FormsByIdResource;
use App\Http\Resources\FormsCollection;
use App\Http\Resources\FormsResource;
use App\Models\Form;
use App\Models\formComplexGroups;
use App\Models\ProjectForm;
use App\Sys\ApiResponse;
use App\Sys\Enums;
use App\Sys\Repository\formComplexGroupsRepo;
use App\Sys\Services\Form\FormService;

//use Barryvdh\DomPDF\Facade\Pdf;
use PDF;
use Illuminate\Http\Request;

class FormController extends Controller
{
    use ApiResponse;

    private $formService;

    public function __construct()
    {
        $this->formService = new FormService();
    }

    public function store(Request $request)
    {
        if ($form = $this->formService->store($request->all())) {
            $data = [
                'id' => $form->id,
                'type' => $form->type,
                "form_group_id" => $form->form_group_id
            ];
            return $this->apiResponse(200, 'done', null, $data);
        }


        return $this->apiResponse(400, 'errors', $this->formService->errors(), null);
    }

    public function continue(Request $request)
    {
        if ($this->formService->continue($request->all()))
            return $this->apiResponse(200, 'done', null, null);

        return $this->apiResponse(400, 'eror', $this->formService->errors(), null);
    }

    public function getByType()
    {

        $forms = $this->formService->FormByType();
        $collect = new FormsCollection($forms);
        return $this->apiResponse(200, 'Forms-type', null, $collect);
    }

    public function getFormType()
    {
        $type = Enums::formTypeEnum();
        return $this->apiResponse(200, 'from -> type', null, $type);
    }

    public function getFormPeriodic()
    {
        $type = Enums::formPeriodicEnum();
        return $this->apiResponse(200, 'form -> periodic_oneTime', null, $type);
    }

    public function getFormPeriodicType()
    {
        $type = Enums::formPeriodicTypeEnum();
        return $this->apiResponse(200, 'form -> periodic_type', null, $type);
    }

    public function getInputType()
    {
        $type = Enums::inputTypeEnum();
        return $this->apiResponse(200, 'rows -> columns-> inputs-> input_type ', null, $type);
    }

    public function getFormChartType()
    {

        $type = Enums::formChartTypeEnum();
        return $this->apiResponse(200, 'rows -> columns-> inputs->chart_type', null, $type);
    }

    public function getFormRowSingleMultiColumn()
    {
        $type = Enums::formRowSingleMultiColumnEnum();
        return $this->apiResponse(200, 'rows ->single_multi_column ', null, $type);
    }

    public function getFormRowSingleMultiInput()
    {

        $type = Enums::formRowSingleMultiInputEnum();
        return $this->apiResponse(200, 'rows -> single_multi_input', null, $type);
    }

    public function getformRowTypeRow()
    {
        $type = Enums::formRowTypeRowEnum();
        return $this->apiResponse(200, 'rows -> type_row', null, $type);
    }

    public function weekDays()
    {
        $type = Enums::weekDaysEnum();
        return $this->apiResponse(200, 'form -> week_day', null, $type);
    }

    public function update(Request $request, $id)
    {
        if ($form = $this->formService->update($id, $request->all())) {
            return $this->apiResponse(200, !empty($this->formService->errors()) ? "Form updated successfully with some errors" : "Form updated successfully", $this->formService->errors(), $form);
        }
        return $this->apiResponse(400, 'error', $this->formService->errors(), null);
    }

    public function generatePDF(Request $request, $ProjectFormId)
    {
        return $url = $this->formService->generatePdf($ProjectFormId);
        //  $url = $this->formService->generatePdf($ProjectFormId);
        if ($url = $this->formService->generatePdf($ProjectFormId)) {
            return $this->apiResponse(200, "success", null, [
                'url' => $url
            ]);
        }

        return $this->apiResponse(400, 'error', $this->formService->errors(), null);
    }

    public function generatePDFApi(Request $request, $ProjectFormId)
    {
        $url = url("api/hes/forms/generate-pdf/{$ProjectFormId}");
        return $this->apiResponse(200, "success", null, [
            'url' => $url
        ]);

        return $this->apiResponse(400, 'error', $this->formService->errors(), null);
    }


    public function lastReport(Request $request, $projectFormId)
    {
        $projectForm = ProjectForm::find($projectFormId);
        if (!$projectForm) {
            return $this->apiResponse(400, 'project form not found', null);
        }
        $lastReport = $projectForm->last_generated_report;

        if (!$lastReport) {
            return $this->apiResponse(400, 'last generated report not found', null);
        }

        return $this->apiResponse(200, 'success', null, [
            "last_report" => $lastReport
        ]);
    }

    public function getAll($type = null)
    {
        $array = $type == null ? ['general', 'fixed'] : [$type];
        $forms = $this->formService->getAllForms($array);
        $collect = new FormsAllCollection($forms);
        return $this->apiResponse(200, 'Forms-type', null, $collect);
    }

    public function getFormByBarnch($id)
    {
        $forms = $this->formService->getByBranch($id);
        $collect = new FormsAllCollection($forms);
        return $this->apiResponse(200, 'Forms-type', null, $collect);
    }

    public function getByid($id)
    {
        $forms = $this->formService->getByid($id);
        $collect = new FormsByIdResource($forms);
        return $this->apiResponse(200, 'Forms-type', null, $collect);
    }

    public function updatedForm(Request $request)
    {
        if ($form = $this->formService->updatedForm($request->all())) {
            $data = [
                'id' => $form->id,
                'type' => $form->type,
                "form_group_id" => $form->form_group_id
            ];
            return $this->apiResponse(200, 'done', null, $data);
        }


        return $this->apiResponse(400, 'errors', $this->formService->errors(), null);
    }

    /**
     * Update ordering values for complex forms.
     *
     * Expects a JSON payload like:
     * {
     *   "forms": [
     *       {"id": 3, "order_of_cycle": 2, "order_of_arrangement": 1, "form_group_id": 2},
     *       {"id": 5},  // no ordering provided => auto-assigned based on count
     *       {"id": 7, "order_of_cycle": 2, "order_of_arrangement": 2, "form_group_id": 2}
     *   ]
     * }
     *
     * @param Request $request
     * @return \Illuminate\Http\Response
     */

    public function updateComplexOrders(Request $request)
    {
        $formsData = $request->all();
        if (!$formsData || !is_array($formsData)) {
            return $this->apiResponse(400, 'Error', 'Invalid input: forms array required', null);
        }

        $updated = $this->formService->updateComplexFormOrders($formsData);
        if ($updated === false) {
            return $this->apiResponse(400, 'Error', $this->formService->errors(), null);
        }
        return $this->apiResponse(200, 'Complex form orders updated successfully', null, FormsResource::collection($updated));
    }

    public function getFormsLogs($id)
    {
        $data = $this->formService->getFormsVersions($id);
        return $this->apiResponse(200,'logs',null,$data);
    }


}
