<?php

namespace App\Http\Controllers;

use App\Http\Resources\FormsAllCollection;
use App\Models\Branch;
use App\Sys\ApiResponse;
use App\Sys\Services\BranchesServices\BranchesServices;
use App\Sys\Services\Form\FormService;
use App\Sys\Services\ProjectsFroms\ProjectsFormServices;
use App\Sys\Services\ProjectsServices\ProjectsServices;
use Illuminate\Http\Request;

class ChartDashboard extends Controller
{
    use ApiResponse;

    private $form;
    private $branch;
    private $project;
    private $projectForm;

    public function __construct()
    {
        $this->form = new FormService();
        $this->branch = new BranchesServices();
        $this->project = new ProjectsServices();
        $this->projectForm = new ProjectsFormServices();
    }

    public function compelatedFroms()
    {
        $data = $this->form->getComaletedFroms();
        return $this->apiResponse(200, 'chart Compelated ', null, $data);
    }

    public function compeledAndNotCompaleted()
    {
        $data = $this->form->getCompaletedNotCompalte();
        return $this->apiResponse(200, 'chart Compelated ', null, $data);
    }

    public function info()
    {
        $form = $this->form->count();
        $branch = $this->branch->count();
        $project = $this->project->count();
        $projectForm = $this->projectForm->count();
        $data = [
            'forms' => $form,
            'branch' => $branch,
            'project' => $project,
            'projectForm' => $projectForm
        ];
        return $this->apiResponse(200, 'chart Compelated ', null, $data);
    }

    public function getFormsChartFixed($type)
    {
        $form = $this->form->getFromChartFixed($type);
        $collect = new FormsAllCollection($form);
        return $this->apiResponse(200, 'chart Compelated ', null, $collect);
    }

    public function FormsChartFixedData($id)
    {
       $from = $this->projectForm->FormChartFixed($id);
        return $this->apiResponse(200, 'chart Compelated ', null, $from);
    }

    public function getFormsChartChart($type ,$id)
    {
        $form = $this->form->getFormsChartChart($type,$id);
        $collect = new FormsAllCollection($form);
        return $this->apiResponse(200, 'chart Compelated ', null, $collect);
    }

    public function getInputs($id)
    {
      $inputs = $this->form->getFormChartInput($id);
       return $this->apiResponse(200, 'chart Compelated ', null, $inputs);

    }

    public function FormsChartChartData(Request $request)
    {
        $data = $this->projectForm->chart($request->all());
        return $this->apiResponse(200, 'chart Compelated ', null, $data);

    }

}
