<?php

namespace App\Http\Controllers\Branches;

use App\Http\Controllers\Controller;
use App\Http\Resources\BranchesCollection;
use App\Sys\ApiResponse;
use App\Sys\Services\BranchesServices\BranchesServices;
use Illuminate\Http\Request;

class BranchesControllers extends Controller
{
    use ApiResponse;
    private $branch;

    public function __construct()
    {
        $this->branch = new BranchesServices();
    }

    public function getBranches()
    {
        $branchs = $this->branch->getAll();
        $collection = new  BranchesCollection($branchs);
        return $this->apiResponse(200, 'All Branches', null, $collection);
    }

    public function BranchUser(Request $request)
    {
        if($this->branch->addUsers($request->all()))
            return $this->apiResponse(200, 'add', null, null);


        $errors = $this->branch->errors();
        return $this->apiResponse(400, 'errors', $errors, null);
    }
    public function createBranch(Request $request)
    {
        if($this->branch->createBranch($request->all()))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->branch->errors();
        return  $this->apiResponse(400,'errors',$errors,null);
    }
    public function showBranch($id)
    {
        $branch = $this->branch->getBranchById($id);

        if(!$branch){
            return $this->apiResponse(400, "error", "Branch not found", null);
        }
        return $this->apiResponse(200, "success", null, $branch);
    }

    public function updateBranch(Request $request)
    {
        if($this->branch->updateBranch($request->all()))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->branch->errors();
        return  $this->apiResponse(400,'errors',$errors,null);
    }

    public function del($id)
    {
        if($this->branch->del($id))
            return $this->apiResponse(200, "success", null, null);


        $errors = $this->branch->errors();
        return  $this->apiResponse(400,'errors',$errors,null);
    }
}

