<?php

namespace App\Http\Controllers;

use App\Http\Resources\ActivityLogCollection;
use App\Sys\ApiResponse;
use Spatie\Activitylog\Models\Activity;

class ActivityLogController extends Controller
{
    use ApiResponse;

    private $inlog = ['user','branch','department','static_page','group','notification_bars','role','project'];
    public function index($log,$id)
    {
        if(in_array($log,$this->inlog))
        {
            $logs = Activity::with(['subject','causer'])->inLog($log)->where('subject_id',$id)->orderBy('created_at','desc')->paginate(20);
            $collect = new ActivityLogCollection($logs);
            return $this->apiResponse(200,'logs',null,$collect);
        }
        return  $this->apiResponse(400,'not Found log','This log name is errors',null);
    }
    public function projectForms($id)
    {
        $logs = Activity::with(['causer'])->inLog('project_form')->where('subject_id',$id)->orderBy('created_at','desc')->paginate(1000);
        $collect = new ActivityLogCollection($logs);
        return $this->apiResponse(200,'logs',null,$collect);
    }
}
