<?php

namespace App\Helpers;

class FormHelper
{
    public static function calculateColumns($row)
    {
        $columnCount = count($row['columns']);
        foreach ($row['columns'] as $column) {
            $input = $column['inputs'][0] ?? null;
            if ($input && $input['input_type'] === 'label') {
                $columnCount--; // Subtract 1 for each label input, as it uses 1 cell instead of 2
            }
        }
        return $columnCount + count(array_filter($row['columns'], fn($col) => isset($col['inputs'][0]) && $col['inputs'][0]['input_type'] === 'label'));
    }
}
